<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function teams()
    {
        return $this->belongsToMany('Team');
    }

    public function company()
    {
        return $this->belongsTo('App\Models\Company');
    }

    public function role()
    {
        return $this->belongsTo('Role');
    }

    public function department()
    {
        return $this->belongsTo('App\Models\Department');
    }

}